@echo off
chcp 65001 >nul 2>&1
title QTTa Igniter - Flash Tool

echo.
echo ========================================
echo   QTTa Igniter - Nahrani firmware
echo ========================================
echo.

:: Check esptool exists
if not exist "%~dp0tools\esptool.exe" (
    echo CHYBA: Soubor tools\esptool.exe nenalezen!
    echo Stahnete esptool z: https://github.com/espressif/esptool/releases
    echo a ulozte jako tools\esptool.exe
    echo.
    pause
    exit /b 1
)

:: Check firmware files exist
if not exist "%~dp0firmware\bootloader.bin" (
    echo CHYBA: firmware\bootloader.bin nenalezen!
    pause
    exit /b 1
)
if not exist "%~dp0firmware\partitions.bin" (
    echo CHYBA: firmware\partitions.bin nenalezen!
    pause
    exit /b 1
)
if not exist "%~dp0firmware\firmware.bin" (
    echo CHYBA: firmware\firmware.bin nenalezen!
    pause
    exit /b 1
)

:: Auto-detect COM port
echo Hledam ESP32 zarizeni...
echo.

set "COM_PORT="
for /f "tokens=1,2,*" %%a in ('"%~dp0tools\esptool.exe" chip_id 2^>^&1') do (
    if "%%a"=="Serial" if "%%b"=="port" (
        for /f "tokens=3" %%p in ("%%a %%b %%c") do set "COM_PORT=%%p"
    )
)

:: Try esptool auto-detect
if "%COM_PORT%"=="" (
    echo Automaticka detekce...
    "%~dp0tools\esptool.exe" chip_id >nul 2>&1
    if %errorlevel% equ 0 (
        echo ESP32 nalezeno.
        set "AUTO_DETECT=1"
    ) else (
        echo.
        echo CHYBA: ESP32 nenalezeno!
        echo.
        echo Zkontrolujte:
        echo   1. Je ESP32 pripojeno USB kabelem?
        echo   2. Jsou nainstalovany ovladace? ^(viz slozka drivers^)
        echo   3. Zkuste podrzet tlacitko BOOT pri pripojovani
        echo.
        echo Pokud znate COM port, zadejte ho ^(napr. COM3^):
        set /p COM_PORT="COM port: "
        if "%COM_PORT%"=="" (
            echo Zadny port nezadan, koncim.
            pause
            exit /b 1
        )
    )
)

echo.
echo ========================================
echo   Nahravam firmware...
echo ========================================
echo.
echo Pokud se nic nedeje, podrzte tlacitko BOOT na ESP32
echo a stisknete RESET ^(EN^).
echo.

if defined AUTO_DETECT (
    "%~dp0tools\esptool.exe" --chip esp32 --baud 460800 write_flash --flash_mode dio --flash_freq 40m --flash_size detect 0x1000 "%~dp0firmware\bootloader.bin" 0x8000 "%~dp0firmware\partitions.bin" 0x10000 "%~dp0firmware\firmware.bin"
) else (
    "%~dp0tools\esptool.exe" --chip esp32 --port %COM_PORT% --baud 460800 write_flash --flash_mode dio --flash_freq 40m --flash_size detect 0x1000 "%~dp0firmware\bootloader.bin" 0x8000 "%~dp0firmware\partitions.bin" 0x10000 "%~dp0firmware\firmware.bin"
)

echo.
if %errorlevel% equ 0 (
    echo ========================================
    echo   HOTOVO! Firmware uspesne nahran.
    echo ========================================
    echo.
    echo Odpojte a znovu pripojte ESP32.
    echo Zarizeni se automaticky spusti.
) else (
    echo ========================================
    echo   CHYBA pri nahravani!
    echo ========================================
    echo.
    echo Zkuste:
    echo   1. Podrzet BOOT a stisknout RESET pri nahravani
    echo   2. Zkusit jiny USB kabel
    echo   3. Nainstalovat ovladace ze slozky drivers
)

echo.
pause
